import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:end_mushroom', {
        onPlayerInteract({ block, player }) {
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                const chance = Math.random();
                if (chance <= 1 / 5) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load end_tree1 ${x - 2} ${y} ${z - 2}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 2 / 5) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load end_tree2 ${x - 2} ${y} ${z - 2}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 3 / 5) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load end_tree3 ${x - 3} ${y} ${z - 3}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 4 / 5) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load end_tree4 ${x - 2} ${y} ${z - 2}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                }
            }
        }
    })
})